
 /*
 * 2011 .3 by level
 */

package android.reader;


import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import android.content.SharedPreferences;
import android.reader.ReaderAndroid;
import android.reader.SerialPortFinder;

public class Application extends android.app.Application {

	public SerialPortFinder mSerialPortFinder = new SerialPortFinder();
	public ReaderAndroid mSerialPort = null;

	public ReaderAndroid getSerialPort() throws SecurityException, IOException, InvalidParameterException {
		if (mSerialPort == null) {
			/* Read serial port parameters from  android.reader_preferences.xml*/
			SharedPreferences sp = getSharedPreferences("android.reader_preferences", MODE_PRIVATE);
			String path = sp.getString("DEVICE", "");
			
			int baudrate = Integer.decode(sp.getString("BAUDRATE", "-1"));			
			if ( (path.length() == 0) || (baudrate == -1)) {
				throw new InvalidParameterException();
			}
			/* Open the serial port */
			mSerialPort = new ReaderAndroid(new File(path), baudrate);
		}
		return mSerialPort;
	}

	public void closeSerialPort() {
		if (mSerialPort != null) {
			mSerialPort.close(mSerialPort.getHandle());
			mSerialPort = null;
		}
	}
}
